/* Dots.java - coded by Simon Lundmark */
/* www.urkburk.com */

import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.swing.*;
import java.util.Random;
import java.awt.image.BufferStrategy;

import javax.sound.sampled.*;
import java.io.File;
import java.net.MalformedURLException;
import java.io.IOException;

public class Dots {

	/*****/

	//                       R                                                 E                                                 M                                                                E                                                 D                                                           Y
	private int[] xCoords = {30, 30, 30,  30,  30, 60, 90, 110, 110,  90, 110, 170, 170, 170, 170, 170, 200, 230, 200, 200, 230, 290, 290, 290, 290, 290, 320, 340, 360, 390, 390, 390, 390, 390, 450, 480, 510, 450, 450, 450, 450, 480, 480, 510, 570, 570, 570, 570, 570, 600, 630, 650, 650, 650, 630, 600, 710, 740, 770, 740, 740, 740};
	//                       R                                                 E                                                 M                                                                E                                                 D                                                           Y
	private int[] yCoords = {30, 60, 90, 120, 150, 30, 30,  60,  90, 120, 150,  30,  60,  90, 120, 150,  30,  30,  90, 150, 150,  30,  60,  90, 120, 150,  60,  90,  60,  30,  60,  90, 120, 150,  30,  30,  30,  60,  90, 120, 150,  90, 150, 150,  30,  60,  90, 120, 150,  30,  30,  60, 120,  90, 150, 150,  30,  60,  30,  90, 120, 150};

	private int refreshRate = 50; // Refresh rate in milliseconds // Integer.parseInt(JOptionPane.showInputDialog("Refresh rate (ms):", "50"));
	private int numberOfDots = xCoords.length; // Number of dots
	private int minRadius = 1; // Minimum dot radius of the dots
	private int maxRadius = 12; // Maximum dot radius of the dots
	private int stepSize = 1; // Step size in pixels - how smooth motion

	private Color dotEdgeColor = new Color(0, 0, 0);
	private Color bgColor = Color.WHITE;
	private int colorCounter1 = 0;
	private int colorCounter2 = 100;
	private int colorCounter3 = 200;
	private boolean expanding = true;
	private Dot[] dots = new Dot[numberOfDots];
	private Random random = new Random();

	private Rectangle bounds;
	private static boolean done = false;
	boolean introDone = false;

	///////



	private static DisplayMode[] BEST_DISPLAY_MODES = new DisplayMode[] {
		new DisplayMode(800, 600, 32, 0),
		new DisplayMode(800, 600, 16, 0)
	};

	JFrame mainFrame;

	public Dots(int numBuffers, GraphicsDevice device) {

		// Create the dots.
		for (int i = 0; i < dots.length; i++) {
			dots[i] = new Dot();
		}

		// Quit when pressing ESCAPE
		KeyListener myKeyListener = new KeyListener() {
			public void keyTyped(KeyEvent e) {}
			public void keyPressed(KeyEvent e) {
				if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
					done = true;
					introDone = true;
				}
			}
			public void keyReleased(KeyEvent e) {}
		};






		try {
			GraphicsConfiguration gc = device.getDefaultConfiguration();
			mainFrame = new JFrame(gc);
			mainFrame.addKeyListener(myKeyListener);
			mainFrame.setUndecorated(true);
			mainFrame.setIgnoreRepaint(true);
			device.setFullScreenWindow(mainFrame);
			if (device.isDisplayChangeSupported()) {
				chooseBestDisplayMode(device);
			}
			bounds = mainFrame.getBounds();
			mainFrame.createBufferStrategy(numBuffers);
			BufferStrategy bufferStrategy = mainFrame.getBufferStrategy();

			// Blank cursor
			int[] pixels = new int[16 * 16];
			Image cursorImage = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, pixels, 0, 16));
			Cursor blankCursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImage, new Point( 0, 0), "");
			mainFrame.setCursor(blankCursor);


/////////////////// Intro

		// Play intro music

			try {
				// From file
				AudioInputStream stream = AudioSystem.getAudioInputStream(new File("music\\intro.wav"));

				// From URL
				//stream = AudioSystem.getAudioInputStream(new URL("http://hostname/audiofile"));

				// At present, ALAW and ULAW encodings must be converted
				// to PCM_SIGNED before it can be played
				AudioFormat format = stream.getFormat();
				if (format.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
					format = new AudioFormat(
							AudioFormat.Encoding.PCM_SIGNED,
							format.getSampleRate(),
							format.getSampleSizeInBits()*2,
							format.getChannels(),
							format.getFrameSize()*2,
							format.getFrameRate(),
							true);        // big endian
					stream = AudioSystem.getAudioInputStream(format, stream);
				}

				// Create the clip
				DataLine.Info info = new DataLine.Info(
					Clip.class, stream.getFormat(), ((int)stream.getFrameLength()*format.getFrameSize()));
				Clip clip = (Clip) AudioSystem.getLine(info);

				// This method does not return until the audio file is completely loaded
				clip.open(stream);

				// Start playing
				clip.start();
				//clip.loop(Clip.LOOP_CONTINUOUSLY);

				// Add a listener for line events
				clip.addLineListener(new LineListener() {
					public void update(LineEvent evt) {
						if (evt.getType() == LineEvent.Type.STOP) {
							introDone = true;
						}
					}
				});


			} catch (MalformedURLException e) {
			} catch (IOException e) {
			} catch (LineUnavailableException e) {
			} catch (UnsupportedAudioFileException e) {
			}

		// Show introtext
			do {
				for (int i = 0; i < numBuffers; i++) {
					Graphics g = bufferStrategy.getDrawGraphics();
					Graphics2D g2d = (Graphics2D)g.create();

					// Turn on antialiasing, so painting is smooth.
					g2d.setRenderingHint(
					RenderingHints.KEY_ANTIALIASING,
					RenderingHints.VALUE_ANTIALIAS_ON);

					if (!bufferStrategy.contentsLost()) {

						g2d.setColor(Color.BLACK);
						g2d.fillRect(0, 0, bounds.width, bounds.height);

						g2d.setColor(Color.GREEN);
						g2d.setFont(new Font("Monospaced", Font.BOLD, 50));
						g2d.drawString("Remedydots by Urkburk", 50, 200);
						g2d.setFont(new Font("Monospaced", Font.BOLD|Font.ITALIC, 25));
						g2d.drawString("Written in Java", 50, 255);
						g2d.drawString("www.urkburk.com", 500, 550);

						bufferStrategy.show();
						g2d.dispose();
					}
					// To set framerate...
					/*try {
						Thread.sleep(3000 / numBuffers);
					} catch (InterruptedException e) {}*/
				}
			} while (!introDone);



/////////////////// Animation


		// Play music

			try {
				// From file
				AudioInputStream stream = AudioSystem.getAudioInputStream(new File("music\\bg.wav"));

				// From URL
				//stream = AudioSystem.getAudioInputStream(new URL("http://hostname/audiofile"));

				// At present, ALAW and ULAW encodings must be converted
				// to PCM_SIGNED before it can be played
				AudioFormat format = stream.getFormat();
				if (format.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
					format = new AudioFormat(
							AudioFormat.Encoding.PCM_SIGNED,
							format.getSampleRate(),
							format.getSampleSizeInBits()*2,
							format.getChannels(),
							format.getFrameSize()*2,
							format.getFrameRate(),
							true);        // big endian
					stream = AudioSystem.getAudioInputStream(format, stream);
				}

				// Create the clip
				DataLine.Info info = new DataLine.Info(
					Clip.class, stream.getFormat(), ((int)stream.getFrameLength()*format.getFrameSize()));
				Clip clip = (Clip) AudioSystem.getLine(info);

				// This method does not return until the audio file is completely loaded
				clip.open(stream);

				// Start playing
				clip.start();
				//clip.loop(Clip.LOOP_CONTINUOUSLY);

				// Add a listener for line events
				clip.addLineListener(new LineListener() {
					public void update(LineEvent evt) {
						if (evt.getType() == LineEvent.Type.STOP) {
							done = true;
						}
					}
				});


			} catch (MalformedURLException e) {
			} catch (IOException e) {
			} catch (LineUnavailableException e) {
			} catch (UnsupportedAudioFileException e) {
			}


			int loops = 0;
			//for (float lag = 2000.0f; lag > 0.00000001f; lag = lag / 3.0f) {
			while (!done) {
				for (int i = 0; i < numBuffers; i++) {
					Graphics g = bufferStrategy.getDrawGraphics();
					Graphics2D g2d = (Graphics2D)g.create();

					// Turn on antialiasing, so painting is smooth.
					g2d.setRenderingHint(
					RenderingHints.KEY_ANTIALIASING,
					RenderingHints.VALUE_ANTIALIAS_ON);

					if (!bufferStrategy.contentsLost()) {

						/* Teh shit */
						rita(g2d);

						bufferStrategy.show();
						g2d.dispose();
					}
					// To set framerate...
                    /*try {
                        Thread.sleep((int)lag);
                    } catch (InterruptedException e) {}*/
				}

				// Some kind of time-out...
				loops++;
				if (loops >= 500) {
					done = true;
				}
			}

		////// EFTERTEXT
			if (done) {

				for (int i = 0; i < numBuffers; i++) {
					Graphics g = bufferStrategy.getDrawGraphics();
					Graphics2D g2d = (Graphics2D)g.create();

					// Turn on antialiasing, so painting is smooth.
					g2d.setRenderingHint(
					RenderingHints.KEY_ANTIALIASING,
					RenderingHints.VALUE_ANTIALIAS_ON);

					if (!bufferStrategy.contentsLost()) {

						g2d.setColor(Color.BLACK);
						g2d.fillRect(0, 0, bounds.width, bounds.height);

						g2d.setColor(Color.GREEN);
						g2d.setFont(new Font("Monospaced", Font.BOLD, 290));
						g2d.drawString("THE", 30, 300);
						g2d.drawString("END", 30, 550);

						bufferStrategy.show();
						g2d.dispose();
					}
					// Sleep
                    try {
                        Thread.sleep(1500 / numBuffers);
                    } catch (InterruptedException e) {}
				}

			}

		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			device.setFullScreenWindow(null);
		}
	}

	private static DisplayMode getBestDisplayMode(GraphicsDevice device) {
		for (int x = 0; x < BEST_DISPLAY_MODES.length; x++) {
			DisplayMode[] modes = device.getDisplayModes();
			for (int i = 0; i < modes.length; i++) {
				if (modes[i].getWidth() == BEST_DISPLAY_MODES[x].getWidth()
				   && modes[i].getHeight() == BEST_DISPLAY_MODES[x].getHeight()
				   && modes[i].getBitDepth() == BEST_DISPLAY_MODES[x].getBitDepth()
				   ) {
					return BEST_DISPLAY_MODES[x];
				}
			}
		}
		return null;
	}

	public static void chooseBestDisplayMode(GraphicsDevice device) {
		DisplayMode best = getBestDisplayMode(device);
		if (best != null) {
			device.setDisplayMode(best);
		}
	}

    private void rita(Graphics2D g2d) {

		// Paint the background.
		//int fooColor = random.nextInt(255);
		g2d.setColor(new Color(random.nextInt(255), random.nextInt(255), random.nextInt(255)));
		//g2d.setColor(bgColor);
		g2d.fillRect(0, 0, bounds.width - 1, bounds.height - 1);

		colorCounter1++;
		colorCounter2++;
		colorCounter3++;

		// Paint the dots
		for (int i = 0; i < dots.length; i++) {
			/* If it's the first paint. */
			if (dots[i].getX() == -1) {

				dots[i].setRadius(minRadius + i % 23);

				dots[i].setColor(new Color(random.nextInt(255), random.nextInt(255), random.nextInt(255)));

				dots[i].setX(xCoords[i]);
				dots[i].setY(yCoords[i] + 200);

				dots[i].setStepSize(stepSize);

				g2d.setColor(dots[i].getColor());
				g2d.fillOval(dots[i].getX() - dots[i].getRadius(), dots[i].getY() - dots[i].getRadius(), dots[i].getRadius() * 2, dots[i].getRadius() * 2);
				g2d.setColor(dotEdgeColor);
				g2d.drawOval(dots[i].getX() - dots[i].getRadius(), dots[i].getY() - dots[i].getRadius(), dots[i].getRadius() * 2, dots[i].getRadius() * 2);

			} else {

			if (dots[i].expanding) {
				dots[i].setRadius(dots[i].getRadius() + dots[i].getStepSize());
				if (dots[i].getRadius() >= maxRadius) {
					dots[i].expanding = false;
				}
			} else {
				dots[i].setRadius(dots[i].getRadius() - dots[i].getStepSize());
				if (dots[i].getRadius() <= minRadius) {
					dots[i].expanding = true;
					if (colorCounter1 > 255) {
						colorCounter1 = 0;
					}
					if (colorCounter2 > 255) {
						colorCounter2 = 0;
					}
					if (colorCounter3 > 255) {
						colorCounter3 = 0;
					}
					dots[i].setColor(new Color(colorCounter1, colorCounter2, colorCounter3));
				}
			}

			g2d.setColor(dots[i].getColor());
			g2d.fillOval(dots[i].getX() - dots[i].getRadius(), dots[i].getY() - dots[i].getRadius(), dots[i].getRadius() * 2, dots[i].getRadius() * 2);
			g2d.setColor(dotEdgeColor);
			g2d.drawOval(dots[i].getX() - dots[i].getRadius(), dots[i].getY() - dots[i].getRadius(), dots[i].getRadius() * 2, dots[i].getRadius() * 2);
			}
		}

	}

	public static void main(String[] args) {

		try {
			int numBuffers = 10;
			GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
			GraphicsDevice device = env.getDefaultScreenDevice();
			Dots test = new Dots(numBuffers, device);
		} catch (Exception e) {
			e.printStackTrace();
		}
		System.exit(0);
	}
}
